<?php

/**
 * This is the model class for table "Biuro".
 *
 * The followings are the available columns in table 'Biuro':
 * @property double $id
 * @property double $powierzchnia
 * @property double $maxPracownikow
 * @property double $cenaWynajem
 * @property double $cenaMedia
 * @property double $idBudynku
 */
class Biuro extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Biuro the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Biuro';
	}

	public function buildingExists()
	{
		$building = Budynek::model()->findByPk($this->idBudynku);
		if(empty($building))
		{
			$this->addError('idBudynku', 'Podany budynek nie istnieje.');
		}
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idBudynku', 'required'),
			array('powierzchnia, maxPracownikow, cenaWynajem, cenaMedia, idBudynku', 'numerical'),
			array('idBudynku', 'buildingExists'),

			array('id, powierzchnia, maxPracownikow, cenaWynajem, cenaMedia, idBudynku', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'budynek'=>array(self::BELONGS_TO, 'Budynek', 'idBudynku'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Biuro', 'ID'),
			'powierzchnia'=>Yii::t('Biuro', 'Powierzchnia [m²]'),
			'maxPracownikow'=>Yii::t('Biuro', 'Ilość pracowników'),
			'cenaWynajem'=>Yii::t('Biuro', 'Cena wynajmu [zł/m-c]'),
			'cenaMedia'=>Yii::t('Biuro', 'Cena mediów [zł/m-c]'),
			'idBudynku'=>Yii::t('Biuro', 'Budynek'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare(Yii::app()->db->quoteColumnName('t.id'), $this->id);
		$criteria->compare(Yii::app()->db->quoteColumnName('powierzchnia'), $this->powierzchnia);
		$criteria->compare(Yii::app()->db->quoteColumnName('maxPracownikow'), $this->maxPracownikow);
		$criteria->compare(Yii::app()->db->quoteColumnName('cenaWynajem'), $this->cenaWynajem);
		$criteria->compare(Yii::app()->db->quoteColumnName('cenaMedia'), $this->cenaMedia);
		$criteria->compare('LOWER("budynek"."nazwa")', strtolower($this->idBudynku), true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
